package AppGioco;

import AppGioco.Quadro.*;

public class TipoLinkGiocato {
	private final Quadro ilQuadro;
	private final Partita laPartita;
	private final int punti;

	public TipoLinkGiocato(Quadro q, Partita p, int n)
			throws EccezionePrecondizioni {
		if (q == null || p == null) // CONTROLLO PRECONDIZIONI
			throw new EccezionePrecondizioni(
					"Gli oggetti devono essere inizializzati");
		ilQuadro = q;
		laPartita = p;
		punti = n;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkGiocato b = (TipoLinkGiocato) o;
			return b.laPartita == laPartita && b.ilQuadro == ilQuadro;
		} else
			return false;
	}

	public int hashCode() {
		return ilQuadro.hashCode() + laPartita.hashCode();
	}

	public Quadro getQuadro() {
		return ilQuadro;
	}

	public Partita getPartita() {
		return laPartita;
	}

	public int getPunti() {
		return punti;
	}

	public String toString() {
		return "(<" + ilQuadro + ", " + laPartita + ">, " + punti + ")";
	}
}
